<?php
// app/Models/User.php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable;

    protected $fillable = [
        'name', 'email', 'username', 'password', 'role', 
        'desa_id', 'dusun_id', 'phone', 'alamat', 'rt', 'rw', 'is_active'
    ];

    protected $hidden = ['password', 'remember_token'];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'is_active' => 'boolean',
    ];

    public function desa()
    {
        return $this->belongsTo(Desa::class);
    }

    public function dusun()
    {
        return $this->belongsTo(Dusun::class);
    }

    public function laporan()
    {
        return $this->hasMany(Laporan::class);
    }

    public function notifikasi()
    {
        return $this->hasMany(Notifikasi::class);
    }

    public function isAdmin()
    {
        return $this->role === 'admin';
    }

    public function isPemdes()
    {
        return $this->role === 'pemdes';
    }
}
